<?php
$mi_posicion1 = 36.38739;
$mi_posicion2 = -6.18387;
?>
<!DOCTYPE html>
<html>

<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes">
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <title>Opening an Infobubble on a Mouse Click</title>
    <link rel="stylesheet" type="text/css" href="https://js.api.here.com/v3/3.1/mapsjs-ui.css" />
    <link rel="stylesheet" type="text/css" href="demo.css" />
    <link rel="stylesheet" type="text/css" href="styles.css" />
    <link rel="stylesheet" type="text/css" href="../template.css" />
    <script type="text/javascript" src='../test-credentials.js'></script>
    <script type="text/javascript" src="https://js.api.here.com/v3/3.1/mapsjs-core.js"></script>
    <script type="text/javascript" src="https://js.api.here.com/v3/3.1/mapsjs-service.js"></script>
    <script type="text/javascript" src="https://js.api.here.com/v3/3.1/mapsjs-ui.js"></script>
    <script type="text/javascript" src="https://js.api.here.com/v3/3.1/mapsjs-mapevents.js"></script>


    <script>
        /** @type {HTMLElement}*/
        var posElt;
        /** @type {HTMLElement} */
        var posLinkElt;


        window.addEventListener('load', function () {
            posElt = document.getElementById('Pos');
            posLinkElt = document.querySelector('#PosLink > a');

            // if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(geoposOK, geoposKO);
            // }
            // else {
            // }
        });

        /** @param {GeolocationPosition} pos */
        function geoposOK(pos) {
            //Obtenemos latitud y longitud
            var lat = pos.coords.latitude;
            var long = pos.coords.longitude;
            //Mostramos la posición
            posElt.textContent = `${lat}, ${long}`;
            //generamos enlace a la posición
            posLinkElt.href = `https://maps.google.com/?q=${lat},${long}`;
            posLinkElt.textContent = 'Mostrar tu posición en un mapa';
        }

        /** @param {GeolocationPositionError} err */
        function geoposKO(err) {
            console.warn(err.message);
            let msg;
            switch (err.code) {
                case err.PERMISSION_DENIED:
                    msg = "No nos has dado permiso para obtener tu posición";
                    break;
                case err.POSITION_UNAVAILABLE:
                    msg = "Tu posición actual no está disponible";
                    break;
                case err.TIMEOUT:
                    msg = "No se ha podido obtener tu posición en un tiempo prudencial";
                    break;
                default:
                    msg = "Error desconocido";
                    break;
            }
            posElt.textContent = msg;
        }


    </script>

</head>

<body id="markers-on-the-map">
    <p>Tu posición es: <span id="Pos">Desconocida</span></p>
    <p id="PosLink"><a target="_blank"></a></p>
    <div class="page-header">
        <h1>Opening an Infobubble on a Mouse Click</h1>
        <p>Open an infobubble when a marker is clicked</p>
    </div>
    <p>This example displays a map with two markers showing the position
        of <b>Liverpool</b> and <b>Manchester City</b> football clubs. Clicking on a
        marker opens an infobubble which holds HTML content related to the marker.</p>
    <div id="map"></div>
    <h3>Code</h3>
    <p>Infobubble opens on <code>tap</code> event, event delegation is used to add event listener to the group that
        holds
        markers.
        <code>setData/getData</code> methods on the map objects are used to bind custom data.
    </p>
    <!--
  <script type="text/javascript" src='demo.js'></script>
-->
    <script>
        /**
    * Creates a new marker and adds it to a group
    * @param {H.map.Group} group       The group holding the new marker
    * @param {H.geo.Point} coordinate  The location of the marker
    * @param {String} html             Data associated with the marker
    */
        function addMarkerToGroup(group, coordinate, html) {
            var marker = new H.map.Marker(coordinate);
            // add custom data to the marker
            marker.setData(html);
            group.addObject(marker);
        }

        /**
         * Add two markers showing the position of Liverpool and Manchester City football clubs.
         * Clicking on a marker opens an infobubble which holds HTML content related to the marker.
         * @param {H.Map} map A HERE Map instance within the application
         */
        function addInfoBubble(map) {
            var group = new H.map.Group();

            map.addObject(group);

            // add 'tap' event listener, that opens info bubble, to the group
            group.addEventListener('tap', function (evt) {
                // event target is the marker itself, group is a parent event target
                // for all objects that it contains
                var bubble = new H.ui.InfoBubble(evt.target.getGeometry(), {
                    // read custom data
                    content: evt.target.getData()
                });
                // show info bubble
                ui.addBubble(bubble);
            }, false);

            addMarkerToGroup(group, { lat: <?php echo $mi_posicion1; ?>, lng: <?php echo $mi_posicion2; ?> },
                '<div><a href="https://maps.google.com/?q=<?php echo $mi_posicion1; ?>,<?php echo $mi_posicion2; ?>" target="_blank">Mi casa</a></div>' +
                '<div>City of Manchester Stadium<br />Capacity: 55,097</div>');

            addMarkerToGroup(group, { lat: 36.39053, lng: -6.18115 },
                '<div><a href="https://www.google.com/maps/dir/36.38739,+-6.18387/36.39053,+-6.18115" target="_blank">Destino</a></div>' +
                '<div>Anfield<br />Capacity: 54,074</div>');

            addMarkerToGroup(group, { lat: 36.38799, lng: -6.17848 },
                '<div><a href="https://www.google.com/maps/dir/36.38739,+-6.18387/36.38799,+-6.17848" target="_blank">Destino</a></div>' +
                '<div>Anfield<br />Capacity: 54,074</div>');

            addMarkerToGroup(group, { lat: 36.39970, lng: -6.16746 },
                '<div><a href="https://www.google.com/maps/dir/36.38739,+-6.18387/36.39970,+-6.16746" target="_blank">Destino</a></div>' +
                '<div>Anfield<br />Capacity: 54,074</div>');

            addMarkerToGroup(group, { lat: 36.39413, lng: -6.15605 },
                '<div><a href="https://www.google.com/maps/dir/36.38739,+-6.18387/36.39413,+-6.15605" target="_blank">Destino</a></div>' +
                '<div>Anfield<br />Capacity: 54,074</div>');

        }

        /**
         * Boilerplate map initialization code starts below:
         */

        // initialize communication with the platform
        // In your own code, replace variable window.apikey with your own apikey
        var platform = new H.service.Platform({
            apikey: 'NvLv0YKby82iVV582lu-MH-mG28uT8dZGsA2RdCQ-Pg'
        });
        var defaultLayers = platform.createDefaultLayers();

        // initialize a map - this map is centered over Europe
        var map = new H.Map(document.getElementById('map'),
            defaultLayers.vector.normal.map, {
            center: { lat: 36.387734051982804, lng: -6.183797211557307 },
            zoom: 17,
            pixelRatio: window.devicePixelRatio || 1
        });

        // add a resize listener to make sure that the map occupies the whole container
        window.addEventListener('resize', () => map.getViewPort().resize());

        // MapEvents enables the event system
        // Behavior implements default interactions for pan/zoom (also on mobile touch environments)
        var behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(map));

        // create default UI with layers provided by the platform
        var ui = H.ui.UI.createDefault(map, defaultLayers);

        // Now use the map as required...
        addInfoBubble(map);

    </script>
</body>

</html>