<?php
// Obtiene el directorio actual
$directorioActual = __DIR__;

// Inicia el HTML con Bootstrap
echo '<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contenido de la Carpeta</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h3 class="mb-4">Contenido de la Carpeta Actual</h3>
        <ul class="list-group">';

// Abrir el directorio actual
if ($handle = opendir($directorioActual)) {
    // Leer cada entrada del directorio
    while (false !== ($entrada = readdir($handle))) {
        // Ignorar las entradas especiales '.' y '..'
        if ($entrada === '.' || $entrada === '..') {
            continue;
        }

        $rutaCompleta = $directorioActual . DIRECTORY_SEPARATOR . $entrada;
        $url = urlencode($entrada); // Codificar el nombre del archivo o carpeta para la URL

        // Mostrar carpetas con enlace
        if (is_dir($rutaCompleta)) {
            echo '<li class="list-group-item">
                    <a href="' . $url . '" class="text-decoration-none">
                        <i class="bi bi-folder-fill text-warning"></i> <strong>' . $entrada . '</strong>
                    </a>
                </li>';
        }
        // Mostrar archivos con enlace
        elseif (is_file($rutaCompleta)) {
            echo '<li class="list-group-item">
                    <a href="' . $url . '" class="text-decoration-none">
                        <i class="bi bi-file-earmark-text-fill text-primary"></i> ' . $entrada . '
                    </a>
                </li>';
        }
    }

    // Cerrar el directorio
    closedir($handle);
} else {
    echo '<div class="alert alert-danger">No se pudo abrir el directorio.</div>';
}

// Cierra el HTML
echo '    </ul>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.js"></script>
</body>
</html>';
?>
