function MostrarOcultarMenu() {
    //console.log("Mostrar ocultar menu");
    const menu = document.querySelector('#nav-1');
    const conten = document.querySelector('#main-1');
    menu.classList.toggle('ocultar');
    conten.classList.toggle('solo-main');
}


const toggleButton = document.querySelector('#btn-dark');

toggleButton.addEventListener('click', () => {
    document.body.classList.toggle('light-mode');
});


// creamos objetos con los menus que tiene submenu
const enlaces = document.querySelectorAll('.nav-item ul');

// recorremos todos y le añadimos evento click
enlaces.forEach(function (enlace) {
    // Caputarmos el id de cada submenu
    const id_submenu = '#' + enlace.id

    // reemplazamos el texto submenu por el link para 
    // saber el id del padre
    const id_menu = enlace.id.replace('submenu-', 'nav-item-')
    //console.log(id_menu);

    // capturamos el id del padre
    const enlace_menu_mostrar = document.querySelector('#' + id_menu);
    // le añadimos el evento click con la funcion mostrar submenu
    // pasandole la id del submenu que queremos mostrar
    enlace_menu_mostrar.addEventListener('click', () => MostrarSubmenu(id_submenu));
})

function MostrarSubmenu(id_submenu) {
    // capturamos el submenu
    const menu = document.querySelector(id_submenu);
    // intercambiamos la clase que oculta
    menu.classList.toggle('ocultar-subnivel');
    menu.classList.toggle('mostrar-subnivel');
    //console.log('click menu');
}



// MENU BUSQUEDA

// capturamos el id del padre
const mostrar_menu_busq = document.querySelector('#busq-flecha');
// le añadimos el evento click con la funcion mostrar submenu
// pasandole la id del submenu que queremos mostrar
mostrar_menu_busq.addEventListener('click', () => {
    const busq = document.querySelector('#busq-avanz');
    busq.classList.toggle('ocultar-subnivel');
});


// FLECHAS MENU HORIZONTAL
const intervalo_movimiento = 150;

const flechaIzq = document.querySelector('#flecha-izq');
flechaIzq.addEventListener('click', () => ClickScroll('izq', 'menu-hz', intervalo_movimiento));

const flechaDch = document.querySelector('#flecha-dch');
flechaDch.addEventListener('click', () => ClickScroll('dch', 'menu-hz', intervalo_movimiento));

function ClickScroll(valor, menu_q, intervalo = 100) {
    const menu = document.querySelector('#' + menu_q);
    let pos1 = menu.scrollLeft + intervalo;
    let pos2 = menu.scrollLeft - intervalo;
    switch (valor) {
        case 'izq':
            //console.log("Click flecha izquierda");                        
            menu.scrollTo({ top: 0, left: pos2, behavior: "smooth" });
            break;
        case 'dch':
            //console.log("Click flecha derecha");
            menu.scrollTo({ top: 0, left: pos1, behavior: "smooth" });
            break;
    }
}