/*
div donde mostrar todos los clientes
    id: lista-clientes

    <ul id="lista-clientes">
    ...
    </ul>

formato: 

    <li class="nav-item">
        <div class="item-nombre">
            <a href="#">Miguel Angel Fernandez</a>
        </div>
        <a href="#" id="nav-item-1"></a>
    </li>
    
    <li class="nav-item"><div class="item-nombre"><a href="#">Miguel Angel Fernandez</a></div><a href="#" id="nav-item-1"></a>
    </li>

input de busqueda
    id: inputBusqueda
*/

import { FUNC_MostrarDatos } from './funciones.js';
import { FUNC_DescargarDatos } from './funciones.js';

/* LA FUNCIÓN GENERAL en serie, primero carga uno y cuando termine carga el otro */
async function CargarClientes(busq = '') {
    try {
        console.log('cargando todo... espere...');

        /* montamos las consulta sql */
        let sql1 = "SELECT cli_id,cli_nombre FROM clientes";

        if (busq !== '') {
            console.log('cargando todo con busqueda... espere...');
            sql1 = "SELECT cli_id,cli_nombre FROM clientes " +
                "WHERE cli_nombre LIKE '" + busq + "%'";
        }

        /* creamos un objeto que contendra cada cliente */
        const cliente_todos = await FUNC_DescargarDatos(sql1);
        //console.log(cliente_todos);

        let total_html = MontarHtmlCliente(cliente_todos);

        FUNC_MostrarDatos(total_html, '#lista-clientes');

        AsignarFuncionClicCliente();


    } catch (error) {
        console.log(error);
    }
}

export { CargarClientes };

function AsignarFuncionClicCliente() {

    /* creamos un funcionalidad en cada click de cargar */
    const cli_det = document.querySelectorAll('.nav-item');
    cli_det.forEach(obj => {
        obj.addEventListener('click', () => {
            const id = obj.id.replace('cli_', '');
            //console.log('click en cliente id ' + id);
            CargarClientesDetalle(id);
        });
    });    
}

function MontarHtmlCliente(lista) {
    let total_html = '';
    if (lista.length > 0) {
        /* creamos un codigo html con los datos recopilados de cada objeto cargado */
        //const html_cliente1 = CrearDatosCliente(cliente_todos,'<div>','</div>');        
        for (const obj of lista) {

            //onclick="VerClienteDetalle(' + obj.cli_id + ')"

            const html_cliente1 =

                '<li class="nav-item" id="cli_' + obj.cli_id + '">' +
                '   <div class="item-nombre">' +
                '       <a class="ver_cliente" href="#" >' + obj.cli_nombre + '</a>' +
                '   </div>' +
                '   <a href="#" id="nav-item-1"></a>' +
                '</li>';
            /*
            '<script>'+
            "const cli_det_"+ obj.cli_id +" = document.querySelector('#cli_"+ obj.cli_id +"');"+
            "cli_det_"+ obj.cli_id +".addEventListener('click', () => {console.log('click detalle');});"+
            '</script>';
            */

            total_html = total_html + html_cliente1;
        }
    } else {
        total_html = "No se encontró clientes."
    }
    return total_html;
}

export { MontarHtmlCliente };



async function CargarClientesDetalle(id) {
    try {
        console.log('cargando cliente id ' + id);

        /* montamos las consulta sql */
        let sql1 = "SELECT * FROM clientes WHERE cli_id = " + id;

        /* creamos un objeto que contendra cada cliente */
        const cliente_todos = await FUNC_DescargarDatos(sql1);
        console.log(cliente_todos);

        let total_html = MontarHtmlClienteDetalle(cliente_todos);
        //console.log(total_html);
        FUNC_MostrarDatos(total_html, '#cabecera_cliente');

        total_html = MontarHtmlClienteDetalle2(cliente_todos);
        //div donde se carga: <div id="clientesDatos">
        FUNC_MostrarDatos(total_html, '#clientesDatos');

    } catch (error) {
        console.log(error);
    }
}

export { CargarClientesDetalle };

function MontarHtmlClienteDetalle(lista) {
    /*
    Cabecera
        id:cabecera_cliente
        formato:
            <h2>Miguel Angel Fernandez</h2>
    */

    let total_html = '';
    if (lista.length > 0) {
        /* creamos un codigo html con los datos recopilados de cada objeto cargado */
        //const html_cliente1 = CrearDatosCliente(cliente_todos,'<div>','</div>');        

        const html_cliente1 =

            '<h2>' + lista[0].cli_nombre + '</h2>';

        total_html = total_html + html_cliente1;

    } else {
        total_html = "No se encontró clientes."
    }
    return total_html;
}

export { MontarHtmlClienteDetalle };

function MontarHtmlClienteDetalle2(lista) {
    /*    
    <div class="clientes-d">ID: <span>425</span></div>
    <div class="clientes-d">Nombre: <span>Miguel Angel Fernandez</span></div>
    <div class="clientes-d">Dirección: <span>C/ Sauce, 35</span></div>
    <div class="clientes-d">Población: <span>Chiclana de la fra.</span></div>
    <div class="clientes-d">CP: <span>11130</span></div>
    <div class="clientes-d">Email: <span>miguel.ang@gmail.com</span></div>
    <div class="clientes-d">Movil: <span>666555111</span></div>
    */

    let total_html = '';
    if (lista.length > 0) {
        /* creamos un codigo html con los datos recopilados de cada objeto cargado */
        //const html_cliente1 = CrearDatosCliente(cliente_todos,'<div>','</div>');        

        const html_cliente1 =
            '<div class="clientes-d">ID: <span id="idCliente">' + CastNull(lista[0].cli_id) + '</span></div>' +
            '<div class="clientes-d">Nombre: <span>' + CastNull(lista[0].cli_nombre) + '</span></div>' +
            '<div class="clientes-d">Dirección: <span>' + CastNull(lista[0].cli_direccion) + '</span></div>' +
            '<div class="clientes-d">Población: <span>' + CastNull(lista[0].cli_poblacion) + '</span></div>' +
            '<div class="clientes-d">CP: <span>' + CastNull(lista[0].cli_cp) + '</span></div>' +
            '<div class="clientes-d">Email: <span></span></div>' +
            '<div class="clientes-d">Movil: <span>' + CastNull(lista[0].cli_tfno) + '</span></div>';
        //'<h2>' + lista[0].cli_nombre + '</h2>';

        total_html = total_html + html_cliente1;

        /* cambiamos el id del boton de modificar con el id */
        const btnModif = document.querySelector('#modificarCliente div');
        btnModif.id = CastNull(lista[0].cli_id)

        /* cambiamos el id del boton de guardar con el id */
        const btnGuardar = document.querySelector('#guardarCliente div');
        btnGuardar.id = CastNull(lista[0].cli_id)

        /* cambiamos los input del formulario modificar */
        const inpNombre = document.querySelector('#modal-nombre');
        inpNombre.value = CastNull(lista[0].cli_nombre);
        const inpDirec = document.querySelector('#modal-direccion');
        inpDirec.value = CastNull(lista[0].cli_direccion);

    } else {
        total_html = "No se encontró clientes."
    }
    return total_html;
}

function CastNull(cadena) {
    if (cadena == null) {
        return '';
    } else {
        return cadena;
    }
}

async function GuardarCliente(id,nombre,direccion) {
    console.log(id + '/' + nombre + '/' + direccion)

    /* montamos las consulta sql */
    let sql1 = "UPDATE clientes SET cli_nombre='" + nombre + "',cli_direccion='" + direccion + "'  WHERE cli_id = " + id;

    /* creamos un objeto que contendra cada cliente */
    const cliente_todos = await FUNC_DescargarDatos(sql1);

    console.log(cliente_todos);

    CargarClientesDetalle(id);
}

export { GuardarCliente };