<?php

function HTML_Head_1($titulo)
{
    echo '<meta http-equiv="X-UA-Compatible" content="IE=edge">' . PHP_EOL . "\t";
    echo '<meta name="viewport" content="width=device-width, initial-scale=1.0">' . PHP_EOL . "\t";
    echo '<title>' . $titulo . '</title>' . PHP_EOL . "\t";
    echo PHP_EOL;
}

function HTML_Head_Style($ruta_css)
{
    // local css
    foreach ($ruta_css as $item) {
        echo '<link rel="stylesheet" href="' . $item . '">' . PHP_EOL . "\t";
    }

}

function HTML_Head_Style_1($ruta_css)
{
    echo '<link rel="stylesheet" href="' . $ruta_css . '">' . PHP_EOL . "\t";
}

function HTML_Head_Icono($ruta)
{
    //icono         
    echo '<link rel="shortcut icon" type="image/x-icon" href="' . $ruta . '">' . PHP_EOL . "\t";
    echo PHP_EOL;
}

function HTML_Head_FontGoogle($familiaFuente)
{
    //style   
    echo '<link rel="preconnect" href="https://fonts.googleapis.com">' . PHP_EOL . "\t";
    echo '<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>' . PHP_EOL . "\t";
    echo '<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=' . $familiaFuente . '">' . PHP_EOL . "\t";
    echo PHP_EOL;
}

function HTML_Head_Script($ruta_JS)
{
    //script
    // local css
    foreach ($ruta_JS as $item) {
        echo '<script src="' . $item . '"></script>' . PHP_EOL . "\t";
    }
    echo PHP_EOL;
}


function MostrarHead($tipo)
{
    $_TITULO_WEB = "Login sesión con PHP y MySQL";
    $_FAMILIA_GOOGLE_FUENTE = "Quicksand:wght@500;700&display=swap";

    $_RUTA_ASSETS = "assets";

    $_RUTA_ICONO = $_RUTA_ASSETS . "/perfil.jpg";


    $_RUTAS_CSS_LOGIN = [
        $_RUTA_ASSETS . "/css/estilos.css",
        $_RUTA_ASSETS . "/css/estilo_login.css",        
        "https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"
    ];

    $_RUTAS_CSS_CLI = [        
        $_RUTA_ASSETS . "/css2/estilo_cliente2.css",        
        $_RUTA_ASSETS . "/css2/variables.css",        
        "https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.0/css/all.min.css"
    ];

    $_RUTAS_JS_LOGIN = [
        "https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js",
        "https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js",
        $_RUTA_ASSETS . "/js/script.js",
        $_RUTA_ASSETS . "/js/script2.js"
    ];
    $_RUTAS_JS_CLI = [
        "https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js",
        "https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js",
        $_RUTA_ASSETS . "/js/script.js",
        $_RUTA_ASSETS . "/js/script2.js"
    ];


    echo '<head>';

    HTML_Head_1($_TITULO_WEB);
    HTML_Head_Icono($_RUTA_ICONO);
    HTML_Head_FontGoogle($_FAMILIA_GOOGLE_FUENTE, );

    switch ($tipo) {
        case 0: //login
            HTML_Head_Style($_RUTAS_CSS_LOGIN);
            HTML_Head_Script($_RUTAS_JS_LOGIN);
            break;
        case 1: //clientes
            HTML_Head_Style($_RUTAS_CSS_CLI);
            HTML_Head_Script($_RUTAS_JS_CLI);
            break;
    }

    echo '</head>';
}
