
const btn1 = document.querySelector('#btnNombre');
btn1.addEventListener('click', () => {
    CargarDatos('-1', 'nombre_completo', '#nombre');
})


function CargarDatos(id, q, div) {
    const url_fetch = './php/consulta.php';
    let searchData = new FormData()
    searchData.append('valor', id)
    searchData.append('query', q)
    try {
        fetch(url_fetch, {
            method: 'POST',
            body: searchData
        })
            .then((resultado) => resultado.json())
            .then((dato) => MostrarDatos(dato, div))
            .catch((error) => {
                console.log('Hay un error');
                console.log(error);
            })
    } catch (error) {
        alert(`${'Hubo un error. Solicitud no procesada. Razones: '}${error.message}`);
        console.log(error);
    }
}

function MostrarDatos(resultado, div) {
    console.log('Promesa Cumplida');
    console.log(resultado);

    const div_nombre = document.querySelector(div);
    div_nombre.innerHTML = "";

    if (resultado.no_record === true) {
        div_nombre.innerHTML = "No encuentra registros"
    } else {
        for (const author of resultado) {
            div_nombre.innerHTML = div_nombre.innerHTML + `<p>${author.first_name} ${author.last_name}</p>`
        }
    }
}