/*
function FUNC_MostrarDatos() {
    console.log('datos')
}
*/

async function FUNC_Cargar() {
    try{
        const resultado = await FUNC_DescargarDatos('-1', 'nombre_completo');
        /* aqui espera hasta que se descarguen todos los clientes */
        FUNC_MostrarDatos(resultado,'#nombre');
    } catch (error) {
        console.log(error);
    }
}

function FUNC_DescargarDatos(id, q) {
    return new Promise( resolve => {
        console.log('Descargando clientes... espere...');
        resolve(FUNC_DescargarCliente(id, q));
    });
}

function FUNC_MostrarDatos(resultado,div) {
    console.log('Promesa Cumplida');
    console.log(resultado);

    const div_nombre = document.querySelector(div);
    div_nombre.innerHTML = "";

    if (resultado.no_record === true) {
        div_nombre.innerHTML = "No encuentra registros"
    } else {
        for (const author of resultado) {
            div_nombre.innerHTML = div_nombre.innerHTML + `<p>${author.first_name} ${author.last_name}</p>`
        }
    }
}

async function FUNC_DescargarCliente(id, q) {
    const url_fetch = './php/consulta.php';
    let searchData = new FormData()
    searchData.append('valor', id)
    searchData.append('query', q)

    const resultado = await fetch(url_fetch, {
        method: 'POST',
        body: searchData
    });
    const datos = await resultado.json();    
    return datos;
}

export{FUNC_Cargar};
