const btn1 = document.querySelector('#button');
btn1.addEventListener('click',function (){
    app();
});

/* CONSULTA 1 */
function descargarNuevosClientes() {
    return new Promise( resolve => {
        console.log('Descargando clientes... espere...');

        setTimeout( () => {
            resolve('Los Clientes fueron Descargados');
        }, 5000 );
    });
}
/* CONSULTA 2 */
function descargarNuevosPedidos() {
    return new Promise( resolve => {
        console.log('Descargando pedidos... espere...');

        setTimeout( () => {
            resolve('Los Pedidos fueron Descargados');
        }, 5000 );
    });
}


/* la función principal la creamos de forma asincrona 
   ponemos un try catch donde llamamos a la promesa con await */
async function app() {
    try{
        /*
        const resultado_cli = await descargarNuevosClientes();
        const resultado_ped = await descargarNuevosPedidos();                
        MostrarResultado(resultado_cli);
        MostrarResultado(resultado_ped);
        */

        const resultado = await Promise.all([descargarNuevosClientes(),descargarNuevosPedidos()]);
        MostrarResultado(resultado[0]);
        MostrarResultado(resultado[1]);
    } catch (error) {
        console.log(error);
    }
}

function MostrarResultado(resultado) {
    console.log(resultado);
}