function MostrarOcultarMenu(id_menu, id_btn, clase_activa) {
    //console.log("Mostrar ocultar menu");
    const menu = document.querySelector('#' + id_menu);
    const btn1 = document.querySelector('#' + id_btn);
    menu.classList.toggle(clase_activa);
    btn1.classList.toggle(clase_activa);

    const asid = document.querySelector('#id-aside');
    asid.classList.toggle('active-aside');
    asid.classList.toggle('desactive-aside-1');

}

const intervalo_movimiento = 150;

const flechaIzq = document.querySelector('#flecha-izq');
flechaIzq.addEventListener('click', () => ClickScroll('izq', 'menu', intervalo_movimiento));

const flechaDch = document.querySelector('#flecha-dch');
flechaDch.addEventListener('click', () => ClickScroll('dch', 'menu', intervalo_movimiento));

function ClickScroll(valor, menu_q, intervalo = 100) {
    const menu = document.querySelector('#' + menu_q);
    let pos1 = menu.scrollLeft + intervalo;
    let pos2 = menu.scrollLeft - intervalo;
    switch (valor) {
        case 'izq':
            //console.log("Click flecha izquierda");                        
            menu.scrollTo({ top: 0, left: pos2, behavior: "smooth" });
            break;
        case 'dch':
            //console.log("Click flecha derecha");
            menu.scrollTo({ top: 0, left: pos1, behavior: "smooth" });
            break;
    }
}

/* CODIGO PARA MOSTRAR Y OCULTAR LOS SUBMENUS CON CLICK */

// creamos objetos con los menus que tiene submenu
const enlaces = document.querySelectorAll('.link-menu ul');

// recorremos todos y le añadimos evento click
enlaces.forEach(function (enlace) {
    // Caputarmos el id de cada submenu
    const id_submenu = '#'+enlace.id
    
    // reemplazamos el texto submenu por el link para 
    // saber el id del padre
    const id_menu = enlace.id.replace('submenu-','link-menu-')
    console.log(id_menu);
    
    // capturamos el id del padre
    const enlace_menu_mostrar = document.querySelector('#'+id_menu);
    // le añadimos el evento click con la funcion mostrar submenu
    // pasandole la id del submenu que queremos mostrar
    enlace_menu_mostrar.addEventListener('click', () => MostrarSubmenu(id_submenu));
})

function MostrarSubmenu(id_submenu) {
    // capturamos el submenu
    const menu = document.querySelector(id_submenu);
    // intercambiamos la clase que oculta
    menu.classList.toggle('ocultar-subnivel');
    menu.classList.toggle('mostrar-subnivel');
    //console.log('click menu');
}







/*
function MostrarOcultarMenu() {
    console.log("Mostrar ocultar menu");
    const menu = document.querySelector('#as-izq');
    console.log(menu); // objeto html

    if (menu.classList.contains("ocultar")){
        menu.classList.remove("ocultar");
        menu.classList.add("motrar");
    } else {
        menu.classList.add("ocultar");
        menu.classList.remove("motrar");
    }
}
*/

