<?php

class CurlController
{

    /*======================================
    RUTA API
    =======================================*/

    static public function api()
    {
        return 'https://band.webrown.es/';
    }


    /*======================================
    PETICIONES API
    =======================================*/


    static public function request_get($url, $method)
    {
        /*https://band.webrown.es/bnd_VISTA_tour_actual?select=*&linkTo=bandas_id&equalTo=1&orderBy=tour_fecha&orderMode=ASC&startAt=3*/

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $method,
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        
        $response = json_decode($response);
        return $response;
    }



    static public function request_post($url, $method, $fields, $header)
    {
        /*https://band.webrown.es/bnd_VISTA_tour_actual?select=*&linkTo=bandas_id&equalTo=1&orderBy=tour_fecha&orderMode=ASC&startAt=3*/

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => $fields,
            CURLOPT_HTTPHEADER => $header
        ));

        $response = curl_exec($curl);    
        curl_close($curl);

        $response = json_decode($response);
        return $response;
    }
}
