<?php
function listarDirectorio($ruta, $nivelCompleto = true, $nivelActual = 0)
{
    if (is_dir($ruta)) {
        $archivos = scandir($ruta);
        echo "<ul>";
        foreach ($archivos as $archivo) {
            if ($archivo != '.' && $archivo != '..') {
                $rutaCompleta = $ruta . DIRECTORY_SEPARATOR . $archivo;
                if (is_dir($rutaCompleta)) {
                    // Mostrar directorio
                    echo "<li><strong>$archivo/</strong></li>";
                    if ($nivelCompleto || $nivelActual == 0) {
                        listarDirectorio($rutaCompleta, $nivelCompleto, $nivelActual + 1); // Recursión
                    }
                } else {
                    // Mostrar archivo con enlace y opción de borrar
                    $urlArchivo = htmlspecialchars($rutaCompleta);
                    echo "<li>
                        <a href='$urlArchivo' target='_blank'>$archivo</a> 
                        <form method='POST' action='' style='display:inline;'>
                            <input type='hidden' name='archivo_a_borrar' value='$urlArchivo'>
                            <button type='submit' onclick='return confirm(\"¿Seguro que deseas eliminar este archivo?\");'>Borrar</button>
                        </form>
                    </li>";
                }
            }
        }
        echo "</ul>";
    } else {
        echo "<p>No es un directorio válido.</p>";
    }
}

// Lógica para eliminar un archivo
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['archivo_a_borrar'])) {
    $archivoABorrar = $_POST['archivo_a_borrar'];
    if (file_exists($archivoABorrar) && is_file($archivoABorrar)) {
        if (unlink($archivoABorrar)) {
            echo "<p>Archivo eliminado: $archivoABorrar</p>";
        } else {
            echo "<p>Error al eliminar el archivo: $archivoABorrar</p>";
        }
    } else {
        echo "<p>El archivo no existe o no es válido.</p>";
    }
}

// Llamar a la función para listar el directorio
$rutaInicial = '.'; // Cambia esto si necesitas otra ruta inicial
//$listarTodo = isset($_GET['listarTodo']) && $_GET['listarTodo'] === 'true'; // Leer parámetro de la URL
//listarDirectorio($rutaInicial, $listarTodo);
?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Directorios y Archivos</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.5;
            margin: 20px;
        }
        ul {
            list-style-type: none;
            padding-left: 20px;
        }
        li {
            margin-bottom: 8px;
        }
        a {
            text-decoration: none;
            color: #007BFF;
        }
        a:hover {
            text-decoration: underline;
        }
        button {
            margin-left: 10px;
            background-color: #FF4D4D;
            color: white;
            border: none;
            padding: 5px 10px;
            cursor: pointer;
        }
        button:hover {
            background-color: #FF0000;
        }
    </style>
</head>
<body>
    <h1>Lista de Directorios y Archivos</h1>
    <p>La siguiente lista muestra la estructura de directorios y archivos. Puedes hacer clic en los archivos para abrirlos o eliminarlos.</p>
    
    <?php listarDirectorio($rutaInicial,true,0); ?>
</body>
</html>
