<?php


function GETConfigBanda($id_banda)
{
    $url = CurlController::api() . 'bnd_config?select=*&linkTo=config_idbanda&equalTo='.$id_banda;
    $method = 'GET';
    $json = CurlController::request_get($url, $method);
    //$total = $json->total;
    $results = $json->results;
    return $results;
}


function GETTourBanda($id_banda,$limite)
{
    $url = CurlController::api() . 'bnd_VISTA_tour_actual?select=*&linkTo=bandas_id&equalTo='.$id_banda.'&startAt='.$limite;
    $method = 'GET';
    $json = CurlController::request_get($url, $method);
    //$total = $json->total;
    $results = $json->results;
    return $results;
}


function GetDateFormatoTour($fecha_tour,$ver_año = 0){
    $fecha = strtotime($fecha_tour);
    $dia = date("d", $fecha);
    $mes = TraducirMesesTour(strtoupper(substr(date("F", $fecha), 0, 3)));    
    $año = date("y", $fecha);
    $time = date("h:m", $fecha);
    if ($ver_año == 0){
        return $dia .' - ' .$mes;        
    } else {
        return $dia .' - ' .$mes.' - ' .$año;        
    }
    
}

function TraducirMesesTour($mes){
    switch ($mes) {
        case 'JAN':
            return 'Ene';            
        case 'FEB':
            return 'Feb';            
        case 'MAR':
            return 'Mar';            
        case 'APR':
            return 'Abr';
        case 'MAY':
            return 'May';
        case 'JUN':
            return 'Jun';            
        case 'JUL':
            return 'Jul';            
        case 'AUG':
            return 'Ago';            
        case 'SEP':
            return 'Sep';            
        case 'OCT':
            return 'Oct';            
        case 'NOV':
            return 'Nov';            
        case 'DIC':
            return 'Dic';            
        default:
            return $mes;            
    }
}


function GETMusicaBanda($id_banda,$limite)
{
    
    $url = CurlController::api() . 'bnd_musica?select=*&linkTo=musica_idbandas&equalTo='.$id_banda.'&orderBy=musica_orden&orderMode=ASC&startAt='.$limite;
    $method = 'GET';
    $json = CurlController::request_get($url, $method);
    //$total = $json->total;
    $results = $json->results;
    return $results;
}


function GETNoticiasBanda($id_banda,$limite)
{
    //https://band.webrown.es/bnd_VISTA_noticias_actual?select=*&linkTo=noticias_idbanda&equalto=3&orderBy=noticias_fecha&orderMode=ASC&startAt=3
    $url = CurlController::api() . 'bnd_VISTA_noticias_actual?select=*&linkTo=noticias_idbanda&equalto='.$id_banda.'&startAt='.$limite;
    $method = 'GET';
    $json = CurlController::request_get($url, $method);
    //$total = $json->total;
    $results = $json->results;
    return $results;
}

function GETVideosBanda($id_banda,$limite)
{    
    $url = CurlController::api() . 'bnd_videos?select=*&linkTo=videos_idbanda&equalto='.$id_banda.'&startAt='.$limite;
    $method = 'GET';
    $json = CurlController::request_get($url, $method);
    //$total = $json->total;
    $results = $json->results;
    return $results;
}

function GETBioBanda($id_banda)
{    
    $url = CurlController::api() . 'bnd_bio?select=*&linkTo=bio_idbanda&equalto='.$id_banda;
    $method = 'GET';
    $json = CurlController::request_get($url, $method);
    //$total = $json->total;
    $results = $json->results;
    return $results;
}

