/**
 * Creates a new marker and adds it to a group
 * @param {H.map.Group} group       The group holding the new marker
 * @param {H.geo.Point} coordinate  The location of the marker
 * @param {String} html             Data associated with the marker
 */
function addMarkerToGroup(group, coordinate, html) {
  var marker = new H.map.Marker(coordinate);
  // add custom data to the marker
  marker.setData(html);
  group.addObject(marker);
}

/**
 * Add two markers showing the position of Liverpool and Manchester City football clubs.
 * Clicking on a marker opens an infobubble which holds HTML content related to the marker.
 * @param {H.Map} map A HERE Map instance within the application
 */
function addInfoBubble(map) {
  var group = new H.map.Group();

  map.addObject(group);

  // add 'tap' event listener, that opens info bubble, to the group
  group.addEventListener('tap', function (evt) {
    // event target is the marker itself, group is a parent event target
    // for all objects that it contains
    var bubble = new H.ui.InfoBubble(evt.target.getGeometry(), {
      // read custom data
      content: evt.target.getData()
    });
    // show info bubble
    ui.addBubble(bubble);
  }, false);

  addMarkerToGroup(group, {lat: 36.38739, lng: -6.18387},
    '<div><a href="https://maps.google.com/?q=36.38739,-6.18387" target="_blank">Mi casa</a></div>' +
    '<div>City of Manchester Stadium<br />Capacity: 55,097</div>');
    
  addMarkerToGroup(group, {lat: 36.39053, lng: -6.18115},
    '<div><a href="https://www.google.com/maps/dir/36.38739,+-6.18387/36.39053,+-6.18115" target="_blank">Destino</a></div>' +
    '<div>Anfield<br />Capacity: 54,074</div>');

  addMarkerToGroup(group, {lat: 36.38799, lng: -6.17848},
    '<div><a href="https://www.google.com/maps/dir/36.38739,+-6.18387/36.38799,+-6.17848" target="_blank">Destino</a></div>' +
    '<div>Anfield<br />Capacity: 54,074</div>');
  
  addMarkerToGroup(group, {lat: 36.39970, lng: -6.16746},
    '<div><a href="https://www.google.com/maps/dir/36.38739,+-6.18387/36.39970,+-6.16746" target="_blank">Destino</a></div>' +
    '<div>Anfield<br />Capacity: 54,074</div>');
  
  addMarkerToGroup(group, {lat: 36.39413, lng: -6.15605},
    '<div><a href="https://www.google.com/maps/dir/36.38739,+-6.18387/36.39413,+-6.15605" target="_blank">Destino</a></div>' +
    '<div>Anfield<br />Capacity: 54,074</div>');
  
}

/**
 * Boilerplate map initialization code starts below:
 */

// initialize communication with the platform
// In your own code, replace variable window.apikey with your own apikey
var platform = new H.service.Platform({
  apikey: 'NvLv0YKby82iVV582lu-MH-mG28uT8dZGsA2RdCQ-Pg'
});
var defaultLayers = platform.createDefaultLayers();

// initialize a map - this map is centered over Europe
var map = new H.Map(document.getElementById('map'),
  defaultLayers.vector.normal.map, {
  center: {lat: 36.387734051982804, lng: -6.183797211557307},
  zoom: 17,
  pixelRatio: window.devicePixelRatio || 1
});

// add a resize listener to make sure that the map occupies the whole container
window.addEventListener('resize', () => map.getViewPort().resize());

// MapEvents enables the event system
// Behavior implements default interactions for pan/zoom (also on mobile touch environments)
var behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(map));

// create default UI with layers provided by the platform
var ui = H.ui.UI.createDefault(map, defaultLayers);

// Now use the map as required...
addInfoBubble(map);
