<?php
$_TITULO_WEB = "Login sesión con PHP y MySQL";
$_FAMILIA_GOOGLE_FUENTE = "Quicksand:wght@500;700&display=swap";

$_RUTA_ASSETS = "/login-brown/assets";

$_RUTA_ICONO = $_RUTA_ASSETS . "/perfil.jpg";
$_RUTAS_CSS = [
    $_RUTA_ASSETS . "/css/estilos.css",        
    $_RUTA_ASSETS . "/css/estilo_login.css",
    $_RUTA_ASSETS . "/css/estilo_sidebar.css",
    $_RUTA_ASSETS . "/css/estilo_sidebar_2.css",
    "https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"
];
$_RUTAS_JS = [
    "https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js",
    "https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js",
    $_RUTA_ASSETS . "/js/script.js",
    $_RUTA_ASSETS . "/js/script2.js"
];


function HTML_Head_1($titulo)
{
    echo '<meta http-equiv="X-UA-Compatible" content="IE=edge">' . PHP_EOL . "\t";
    echo '<meta name="viewport" content="width=device-width, initial-scale=1.0">' . PHP_EOL . "\t";
    echo '<title>' . $titulo . '</title>' . PHP_EOL . "\t";
    echo PHP_EOL;
}

function HTML_Head_Style($ruta_css)
{
    // local css
    foreach ($ruta_css as $item) {
        echo '<link rel="stylesheet" href="' . $item . '">' . PHP_EOL . "\t";
    }
    
}

function HTML_Head_Style_1($ruta_css) 
{
    echo '<link rel="stylesheet" href="' . $ruta_css . '">' . PHP_EOL . "\t";    
}

function HTML_Head_Icono($ruta)
{
    //icono         
    echo '<link rel="shortcut icon" type="image/x-icon" href="' . $ruta . '">' . PHP_EOL . "\t";
    echo PHP_EOL;
}

function HTML_Head_FontGoogle($familiaFuente)
{
    //style   
    echo '<link rel="preconnect" href="https://fonts.googleapis.com">' . PHP_EOL . "\t";
    echo '<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>' . PHP_EOL . "\t";
    echo '<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=' . $familiaFuente . '">' . PHP_EOL . "\t";
    echo PHP_EOL;
}

function HTML_Head_Script($ruta_JS)
{
    //script
    // local css
    foreach ($ruta_JS as $item) {
        echo '<script src="' . $item . '"></script>' . PHP_EOL . "\t";
    }
    echo PHP_EOL;
}
?>

<head>
    <?php HTML_Head_1($_TITULO_WEB); ?>
    <?php HTML_Head_Icono($_RUTA_ICONO); ?>
    <?php HTML_Head_FontGoogle($_FAMILIA_GOOGLE_FUENTE, ); ?>
    <?php HTML_Head_Style($_RUTAS_CSS); ?>
    <?php HTML_Head_Script($_RUTAS_JS); ?>
</head>